﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

//CustomSlider internally manages a Unity slider but adds custom logic and properties to it
public class CustomSlider : MonoBehaviour
{
    //Public properties
    public string Header;
    public bool ValueAsPercentage = false;

    //UI elements
    private TMP_Text _HeaderText;
    private TMP_Text _ValueText;
    private Slider _Slider;

    void Start()
    {
        //Get the UI elements
        _HeaderText = gameObject.FindChild("Header").GetComponent<TMP_Text>();
        _ValueText = gameObject.FindChild("Value").GetComponent<TMP_Text>();
        _Slider = gameObject.GetComponent<Slider>();
    }

    void Update()
    {
        //Update the header and the value as appropriate based on the properties
        _HeaderText.text = Header;

        if (ValueAsPercentage)
        {
            _ValueText.text = Mathf.RoundToInt(((_Slider.value / _Slider.maxValue) * 100.0f)).ToString() + "%";
        }

        else
        {
            _ValueText.text = _Slider.value.ToString();
        }
    }
}
